//---------------------------------------------------------------------------
#include "Mensagens_Erros.h"
#include "Class_Sprite.h"
//---------------------------------------------------------------------------
TSprite::TSprite(char *nome, bool buffer, TColor cortransp, int width, int height)
{
	NomeArquivo = new AnsiString(nome);
	transparente = cortransp;
	this->height = height;
	this->width = width;
	this->buffer = buffer;

	Reload();
}
//---------------------------------------------------------------------------
TSprite::~TSprite()
{
	delete NomeArquivo;
	destroy_bitmap(Sprite);
	if(buffer)
		destroy_bitmap(SpriteBuffer);
	delete []pos_sprite;
}
//---------------------------------------------------------------------------
int TSprite::QuantSprites()
{
	return nSprites;
}
//---------------------------------------------------------------------------
bool TSprite::Reload()
{
	int i,x,y;

	xant = -0xFFFF;
	yant = -0xFFFF;

	Sprite = load_bitmap(NomeArquivo->c_str(), palette);
	if(Sprite == NULL)
	{
		allegro_message(NomeArquivo->c_str());
		return false;
	}

	if(buffer)
	{
		SpriteBuffer = create_bitmap(width, height);
		if(SpriteBuffer==NULL)
		{
			allegro_message(NomeArquivo->c_str());
			return false;
		}
		clear_to_color(SpriteBuffer, bitmap_mask_color(screen));
	}

	for (y = 0; y < Sprite->h; y++)
		for (x = 0; x < Sprite->w; x++)
			if (getpixel(Sprite, x, y) == transparente)
				putpixel(Sprite, x, y, bitmap_mask_color(screen)); 	 

	nSprites=(Sprite->w/width)*(Sprite->h/height);

	try
	{
		pos_sprite = new POINT[nSprites];
	}
	catch(...)
	{
		allegro_message("Sem memoria!");
		pos_sprite=NULL;
		return false;
	}

	for(i=0,x=0,y=0;i<nSprites;i++)
	{
		pos_sprite[i].x = x;
		pos_sprite[i].y = y;
		x+= width;
		if(x >= Sprite->w)
		{
			x=0;
			y+= height;
		}
	}
	return true;
}
//---------------------------------------------------------------------------
void TSprite::Draw(BITMAP *hdcdest, int x, int y, int nsprite)
{
	int xo,yo;

	if(nsprite >= nSprites || nsprite < 0)
		nsprite=0;

	xo = pos_sprite[nsprite].x;
	yo = pos_sprite[nsprite].y;

	if(buffer == true)
	{
		blit(hdcdest, SpriteBuffer, x, y, 0, 0, width, height);
		xant = x;
		yant = y;
	}

	masked_blit(Sprite, hdcdest, xo, yo, x, y, width, height);
}
//---------------------------------------------------------------------------
/*
void TSprite::DrawRotate(HDC hdcdest, int x, int y, int nsprite, DIRECAO_SPRITE dir)
{
        int xo,yo;
        static int xi,yi,xf,yf;

        if(nsprite>=nSprites||nsprite<0)
                nsprite=0;

        xo=pos_sprite[nsprite].x;
        yo=pos_sprite[nsprite].y;

        switch(dir)
        {
                case ESQ_SPRITE:
                case CIM_SPRITE:
                        xi=x;
                        yi=y;
                        xf=width;
                        yf=height;
                        break;
                case DIR_SPRITE:
                        xi=x+width-1;
                        yi=y;
                        xf=-width;
                        yf=height;
                        break;
                case BAI_SPRITE:
                        xi=x;
                        yi=y+height-1;
                        xf=width;
                        yf=-height;
                        break;
        }

	if(buffer == true)
	{
		BitBlt(SpriteBuffer->Canvas->Handle,0,0,width,height,hdcdest,x,y,SRCCOPY);
		xant=x;
		yant=y;
	}

	StretchBlt(hdcdest,xi,yi,xf,yf,SpriteMask->Canvas->Handle,xo,yo,width,height,SRCAND);
	StretchBlt(hdcdest,xi,yi,xf,yf,Sprite->Canvas->Handle,xo,yo,width,height,SRCPAINT);
}
*/
//---------------------------------------------------------------------------
void TSprite::ResetBuffer()
{
	this->xant=-0xFFFF;
	this->yant=-0xFFFF;
}
//---------------------------------------------------------------------------
void TSprite::DrawBuffer(BITMAP *hdcdest)
{
	if(xant == -0xFFFF || yant == -0xFFFF)
		return;

	blit(SpriteBuffer, hdcdest, 0, 0, xant, yant, width, height);
}
//---------------------------------------------------------------------------
/*
void TSprite::EnableBuffer(bool conf)
{
        if(conf==true&&BufferConf==false)
        {
                try
                {
                        SpriteBuffer= new Graphics::TBitmap();
                }
                catch(...)
                {
                        MessageBox(NULL,ERR_SEM_MEMORIA,TITLE_TSPRITE,MB_ICONEXCLAMATION);
                        return;
                }
                SpriteBuffer->Assign(Sprite);
                SpriteBuffer->Width = width;
                SpriteBuffer->Height = height;
        }
        else if(conf==false&&BufferConf==true)
        {
                delete SpriteBuffer;
        }
        BufferConf=conf;
}
//---------------------------------------------------------------------------
void TSprite::PlayResource(char *name)
{
	PlaySound(name,(void *)HInstance,SND_RESOURCE|SND_ASYNC);
}
//---------------------------------------------------------------------------
*/
